/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import jclass.bwt.BWTUtil;
import jclass.bwt.JCContainer;
import jclass.bwt.JCSerializable;
import jclass.chart.Changeable;
import jclass.chart.ChartCanvas;
import jclass.chart.ChartConverter;
import jclass.chart.ChartDataView;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.ChartText;
import jclass.chart.EventTrigger;
import jclass.chart.JCAboutBox;
import jclass.chart.JCAxis;
import jclass.chart.JCAxisTitle;
import jclass.chart.JCChartArea;
import jclass.chart.JCChartEvent;
import jclass.chart.JCChartLabel;
import jclass.chart.JCChartListener;
import jclass.chart.JCChartStyle;
import jclass.chart.JCChartUtil;
import jclass.chart.JCDataIndex;
import jclass.chart.JCLegend;
import jclass.chart.JCPickEvent;
import jclass.chart.JCPickListener;
import jclass.chart.JCTitle;
import jclass.chart.JCValueLabel;
import jclass.chart.PropertyFrame;
import jclass.chart.Timer;
import jclass.chart.TimerListener;
import jclass.util.JCEnvironment;
import jclass.util.JCRectList;
import jclass.util.JCRectUtil;
import jclass.util.JCString;
import jclass.util.JCVector;

public class JCChart
extends JCContainer
implements Changeable,
JCSerializable,
KeyListener,
MouseListener,
MouseMotionListener,
TimerListener {
    JCChartArea chartArea;
    JCLegend legend;
    JCTitle footer;
    JCTitle header;
    boolean isBatched = false;
    boolean doubleBuffer = true;
    boolean allowUserChanges = false;
    JCVector triggers = new JCVector();
    JCVector listeners = new JCVector();
    JCVector pickListeners = new JCVector();
    JCVector data = new JCVector();
    JCVector dwellLabels;
    JCChartLabel currentDwellLabel;
    int dwellPointerX;
    int dwellPointerY;
    Timer timer;
    Insets margins = new Insets(1, 1, 1, 1);
    public static final int NONE = -1;
    public static final int PLOT = 0;
    public static final int SCATTER_PLOT = 1;
    public static final int POLAR = 2;
    public static final int RADAR = 3;
    public static final int FILLED_RADAR = 4;
    public static final int HILO = 5;
    public static final int HILO_OPEN_CLOSE = 6;
    public static final int CANDLE = 7;
    public static final int AREA = 8;
    public static final int BAR = 9;
    public static final int STACKING_BAR = 10;
    public static final int PIE = 11;
    Dimension prefSize = new Dimension(-1, -1);
    int offset = 5;
    int resetKey = 114;
    int cancelKey = 99;
    private boolean changed = false;
    String url;
    private PropertyFrame myPropertyFrame;
    public static final Date expiry = new Date(97, 4, 1);
    public static final Date current = new Date();
    Point first;
    Point last;
    public static int os = JCEnvironment.BROWSER_UNKNOWN;
    public static int browser = JCEnvironment.BROWSER_UNKNOWN;
    int lastx;
    int lasty;

    public static final boolean expired() {
        return false;
    }

    private void init() {
        this.setLayout(null);
        this.header = new JCTitle();
        this.header.setParentChart(this);
        this.chartArea = new JCChartArea();
        this.chartArea.setParentChart(this);
        this.footer = new JCTitle();
        this.footer.setParentChart(this);
        this.legend = new JCLegend();
        this.legend.setParentChart(this);
        this.header.addKeyListener(this);
        this.header.addMouseListener(this);
        this.header.addMouseMotionListener(this);
        this.footer.addKeyListener(this);
        this.footer.addMouseListener(this);
        this.footer.addMouseMotionListener(this);
        this.legend.addKeyListener(this);
        this.legend.addMouseListener(this);
        this.legend.addMouseMotionListener(this);
        this.chartArea.addKeyListener(this);
        this.chartArea.addMouseListener(this);
        this.chartArea.addMouseMotionListener(this);
        this.addDataView(0);
        JCChartStyle.resetDefaults();
        this.enableEvents(16L);
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (this.allowUserChanges && mouseEvent.isPopupTrigger()) {
            this.setCursor(3);
            if (this.myPropertyFrame == null) {
                this.myPropertyFrame = new PropertyFrame(this.getClass().getName());
                this.myPropertyFrame.setValue(this);
                this.myPropertyFrame.move(mouseEvent.getX(), mouseEvent.getY());
            } else {
                this.myPropertyFrame.show();
            }
            this.setCursor(0);
            return;
        }
        super.processMouseEvent(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Event event = new Event(this, mouseEvent.getWhen(), mouseEvent.getID(), mouseEvent.getX() + mouseEvent.getComponent().location().x, mouseEvent.getY() + mouseEvent.getComponent().location().y, 0, mouseEvent.getModifiers());
        event.clickCount = mouseEvent.getClickCount();
        this.mouseDown(event, event.x, event.y);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Event event = new Event(this, mouseEvent.getWhen(), mouseEvent.getID(), mouseEvent.getX() + mouseEvent.getComponent().location().x, mouseEvent.getY() + mouseEvent.getComponent().location().y, 0, mouseEvent.getModifiers());
        event.clickCount = mouseEvent.getClickCount();
        this.mouseUp(event, event.x, event.y);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        Event event = new Event(this, mouseEvent.getWhen(), mouseEvent.getID(), mouseEvent.getX() + mouseEvent.getComponent().location().x, mouseEvent.getY() + mouseEvent.getComponent().location().y, 0, mouseEvent.getModifiers());
        this.mouseExit(event, event.x, event.y);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Event event = new Event(this, mouseEvent.getWhen(), mouseEvent.getID(), mouseEvent.getX() + mouseEvent.getComponent().location().x, mouseEvent.getY() + mouseEvent.getComponent().location().y, 0, mouseEvent.getModifiers());
        this.mouseDrag(event, event.x, event.y);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Event event = new Event(this, mouseEvent.getWhen(), mouseEvent.getID(), mouseEvent.getX() + mouseEvent.getComponent().location().x, mouseEvent.getY() + mouseEvent.getComponent().location().y, 0, mouseEvent.getModifiers());
        event.clickCount = mouseEvent.getClickCount();
        this.mouseMove(event, event.x, event.y);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Event event = new Event(this, keyEvent.getWhen(), keyEvent.getID(), keyEvent.getComponent().location().x, keyEvent.getComponent().location().y, 0, keyEvent.getModifiers());
        this.keyDown(event, keyEvent.getKeyChar());
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public JCChart(int n) {
        this.init();
        ((ChartDataView)this.data.elementAt(0)).setChartType(n);
    }

    public JCChart() {
        try {
            this.init();
            ((ChartDataView)this.data.elementAt(0)).setChartType(0);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return;
        }
    }

    public JCChart(Applet applet, String string) {
        super(applet, string);
        this.init();
        ((ChartDataView)this.data.elementAt(0)).setChartType(0);
        if (this.getClass().getName().equals("jclass.chart.JCChart")) {
            this.getParameters(applet);
        }
    }

    Applet getApplet() {
        return this.applet;
    }

    protected void getParameters() {
        super.getParameters();
        ChartConverter.getParams(this);
    }

    String getParam(String string) {
        return JCContainer.getConverter().getParam(this.applet, this, this.getName(), string);
    }

    public final boolean isChanged() {
        return this.getChanged();
    }

    public boolean getChanged() {
        return this.chartArea.isChanged() || this.legend.isChanged() || this.header.isChanged() || this.footer.isChanged();
    }

    public void recalc() {
        if (!this.isChanged()) {
            return;
        }
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof ChartCanvas) {
                ((ChartCanvas)componentArray[n]).recalc();
            }
            ++n;
        }
        this.setChanged(false);
    }

    public void setChanged(boolean bl) {
        if (bl == this.changed) {
            return;
        }
        this.changed = bl;
        if (this.changed) {
            if (this.getIsBatched()) {
                this.invalidate();
                return;
            }
            this.update();
        }
    }

    public void setChanged(boolean bl, boolean bl2) {
        if (bl2) {
            this.setChanged(bl);
            return;
        }
        this.changed = bl;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((JCChartListener)enumeration.nextElement()).paintChart(this);
        }
    }

    public void printAll(Graphics graphics) {
        super.printAll(graphics);
    }

    public void print(Graphics graphics) {
        super.print(graphics);
        this.printComponents(graphics);
    }

    public void layout() {
        FontMetrics fontMetrics;
        Font font;
        this.recalc();
        Dimension dimension = this.size();
        dimension.width -= this.margins.left + this.margins.right;
        dimension.height -= this.margins.top + this.margins.bottom;
        Dimension dimension2 = this.header.preferredSize();
        Dimension dimension3 = this.footer.preferredSize();
        Dimension dimension4 = this.legend.preferredSize();
        Dimension dimension5 = new Dimension(this.chartArea.getWidth(), this.chartArea.getHeight());
        Point point = new Point(this.chartArea.getLeft(), this.chartArea.getTop());
        Point point2 = new Point(this.legend.getLeft(), this.legend.getTop());
        Point point3 = new Point(this.header.getLeft(), this.header.getTop());
        Point point4 = new Point(this.footer.getLeft(), this.footer.getTop());
        double d = 0.75;
        int n = 0;
        if (this.header.isShowing) {
            font = this.legend.getFont();
            fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            n = fontMetrics.getHeight();
        }
        int n2 = 0;
        if (this.header.isShowing) {
            font = this.header.getFont();
            fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            n2 = fontMetrics.getHeight();
        }
        int n3 = 0;
        if (this.footer.isShowing) {
            font = this.footer.getFont();
            fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            n3 = fontMetrics.getHeight();
        }
        Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        int n4 = this.legend.getAnchor();
        if (this.legend.getTopIsDefault()) {
            block0 : switch (n4 & 0xF0) {
                case 16: {
                    switch (n4 & 0xF) {
                        case 1: 
                        case 2: {
                            point2.y = rectangle.y + (int)(d * (double)n);
                            break block0;
                        }
                    }
                    point2.y = (int)((double)rectangle.y + 2.0 * d * (double)n2 + d * (double)n + (double)dimension2.height);
                    break;
                }
                case 32: {
                    switch (n4 & 0xF) {
                        case 1: 
                        case 2: {
                            point2.y = rectangle.y + rectangle.height - ((int)(d * (double)n) + dimension4.height);
                            break block0;
                        }
                    }
                    point2.y = rectangle.y + rectangle.height - ((int)(d * (double)n) + (int)(2.0 * d * (double)n3) + dimension4.height + dimension3.height);
                    break;
                }
                default: {
                    point2.y = (rectangle.height - dimension4.height) / 2;
                }
            }
            point2.y = JCChartUtil.clamp(point2.y, 0, rectangle.height);
        }
        if (this.legend.getLeftIsDefault()) {
            switch (n4 & 0xF) {
                case 1: {
                    point2.x = rectangle.x + rectangle.width - (int)(d * (double)n) - dimension4.width;
                    break;
                }
                case 2: {
                    point2.x = rectangle.x + (int)(d * (double)n);
                    break;
                }
                default: {
                    point2.x = (rectangle.width - dimension4.width) / 2;
                }
            }
            point2.x = JCChartUtil.clamp(point2.x, 0, rectangle.width);
        }
        Rectangle rectangle2 = new Rectangle(point3, dimension2);
        if (this.header.getLeftIsDefault()) {
            rectangle2.x = (rectangle.width - rectangle2.width) / 2;
            rectangle2.x = JCChartUtil.clamp(rectangle2.x, 0, rectangle.width);
        }
        if (this.header.getTopIsDefault()) {
            rectangle2.y = rectangle.y + (int)(d * (double)n2);
            rectangle2.y = JCChartUtil.clamp(rectangle2.y, 0, rectangle.height);
        }
        Rectangle rectangle3 = new Rectangle(point4, dimension3);
        if (this.footer.getLeftIsDefault()) {
            rectangle3.x = (rectangle.width - rectangle3.width) / 2;
            rectangle3.x = JCChartUtil.clamp(rectangle3.x, 0, rectangle.width);
        }
        if (this.footer.getTopIsDefault()) {
            rectangle3.y = rectangle.y + rectangle.height - rectangle3.height - (int)(d * (double)n3);
            rectangle3.y = JCChartUtil.clamp(rectangle3.y, 0, rectangle.height);
        }
        Rectangle rectangle4 = new Rectangle(point, dimension5);
        if (this.chartArea.getLeftIsDefault() || this.chartArea.getTopIsDefault() || this.chartArea.getWidthIsDefault() || this.chartArea.getHeightIsDefault()) {
            Rectangle rectangle5;
            JCRectList jCRectList = new JCRectList();
            JCRectUtil.rl_init(rectangle, jCRectList);
            if (this.legend.isShowing) {
                JCRectUtil.rl_remove(new Rectangle(point2, dimension4), jCRectList, jCRectList);
            }
            if (this.header.isShowing) {
                rectangle5 = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                if (this.header.getLeftIsDefault()) {
                    rectangle5.x = 0;
                    rectangle5.width = rectangle.width;
                }
                JCRectUtil.rl_remove(rectangle5, jCRectList, jCRectList);
            }
            if (this.footer.isShowing) {
                rectangle5 = new Rectangle(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                if (this.footer.getLeftIsDefault()) {
                    rectangle5.x = 0;
                    rectangle5.width = rectangle.width;
                }
                JCRectUtil.rl_remove(rectangle5, jCRectList, jCRectList);
            }
            Rectangle rectangle6 = jCRectList.head != null ? JCRectUtil.largest_rect(jCRectList) : new Rectangle(0, 0, 0, 0);
            int n5 = rectangle6.width / 40;
            int n6 = rectangle6.height / 40;
            point.x = rectangle6.x + n5;
            dimension5.width = rectangle6.width - n5 * 2;
            point.y = rectangle6.y + n6;
            dimension5.height = rectangle6.height - n6 * 2;
        }
        if (!this.chartArea.getLeftIsDefault()) {
            if (this.chartArea.getWidthIsDefault()) {
                dimension5.width -= rectangle4.x - point.x;
                dimension5.width = Math.max(0, dimension5.width);
            }
            point.x = rectangle4.x;
        }
        if (!this.chartArea.getTopIsDefault()) {
            if (this.chartArea.getHeightIsDefault()) {
                dimension5.height -= rectangle4.y - point.y;
                dimension5.height = Math.max(0, dimension5.height);
            }
            point.y = rectangle4.y;
        }
        if (!this.chartArea.getHeightIsDefault()) {
            dimension5.height = rectangle4.height;
        }
        if (!this.chartArea.getWidthIsDefault()) {
            dimension5.width = rectangle4.width;
        }
        if (dimension5.width > Integer.MAX_VALUE) {
            dimension5.width = 0;
        }
        if (dimension5.height > Integer.MAX_VALUE) {
            dimension5.height = 0;
        }
        if (this.header.getLeftIsDefault()) {
            point3.x = point.x + (dimension5.width - rectangle2.width) / 2;
            point3.x = Math.max(0, point3.x);
        }
        if (this.header.getTopIsDefault()) {
            point3.y = rectangle2.y;
        }
        if (this.footer.getLeftIsDefault()) {
            point4.x = point.x + (dimension5.width - rectangle3.width) / 2;
            point4.x = Math.max(0, point4.x);
        }
        if (this.footer.getTopIsDefault()) {
            point4.y = rectangle3.y;
        }
        this.legend.reshape(point2.x + this.margins.left, point2.y + this.margins.top, dimension4.width, dimension4.height);
        this.header.reshape(point3.x + this.margins.left, point3.y + this.margins.top, dimension2.width, dimension2.height);
        this.chartArea.reshape(point.x + this.margins.left, point.y + this.margins.top, dimension5.width, dimension5.height);
        this.footer.reshape(point4.x + this.margins.left, point4.y + this.margins.top, dimension3.width, dimension3.height);
    }

    public Dimension preferredSize() {
        this.recalc();
        if (this.prefSize.width >= 0 && this.prefSize.height >= 0) {
            return this.prefSize;
        }
        this.prefSize = this.chartArea.preferredSize();
        if (this.header.getIsShowing()) {
            this.prefSize.width = Math.max(this.header.preferredSize().width, this.prefSize.width);
            this.prefSize.height += this.header.preferredSize().height + this.offset;
        }
        if (this.footer.getIsShowing()) {
            this.prefSize.width = Math.max(this.footer.preferredSize().width, this.prefSize.width);
            this.prefSize.height += this.footer.preferredSize().height + this.offset;
        }
        Dimension dimension = this.legend.preferredSize();
        if (this.legend.getIsShowing()) {
            int n = this.legend.anchor;
            switch (n) {
                case 17: 
                case 18: 
                case 33: 
                case 34: {
                    this.prefSize.width += dimension.width + this.offset;
                    this.prefSize.height += dimension.height + this.offset;
                    break;
                }
                case 16: 
                case 32: {
                    this.prefSize.width = Math.max(this.prefSize.width, dimension.width);
                    this.prefSize.height += dimension.height + this.offset;
                    break;
                }
                case 1: 
                case 2: {
                    this.prefSize.width += dimension.width + this.offset;
                    this.prefSize.height = Math.max(this.prefSize.height, dimension.height);
                    break;
                }
            }
        }
        this.prefSize.width += this.margins.left + this.margins.right;
        this.prefSize.height += this.margins.top + this.margins.bottom;
        return this.prefSize;
    }

    public Dimension minimumSize() {
        return this.preferredSize();
    }

    public synchronized void setIsBatched(boolean bl) {
        if (this.isBatched == bl) {
            return;
        }
        this.isBatched = bl;
        if (!this.isBatched) {
            this.update();
        }
    }

    public boolean getIsBatched() {
        return this.isBatched;
    }

    public void update() {
        this.invalidate();
        if (this.getPeer() == null) {
            return;
        }
        this.validate();
        this.repaint();
    }

    public synchronized void setDoubleBuffer(boolean bl) {
        this.doubleBuffer = bl;
        this.header.setDoubleBuffer(this.doubleBuffer);
        this.footer.setDoubleBuffer(this.doubleBuffer);
        this.legend.setDoubleBuffer(this.doubleBuffer);
        this.chartArea.setDoubleBuffer(this.doubleBuffer);
    }

    public boolean getDoubleBuffer() {
        return this.doubleBuffer;
    }

    public synchronized void setAllowUserChanges(boolean bl) {
        this.allowUserChanges = bl;
    }

    public boolean getAllowUserChanges() {
        return this.allowUserChanges;
    }

    public JCTitle getHeader() {
        return this.header;
    }

    public void setHeader(JCTitle jCTitle) {
        if (jCTitle == null) {
            return;
        }
    }

    public JCTitle getFooter() {
        return this.footer;
    }

    public void setFooter(JCTitle jCTitle) {
        if (jCTitle == null) {
            return;
        }
    }

    public JCLegend getLegend() {
        return this.legend;
    }

    public void setLegend(JCLegend jCLegend) {
        if (jCLegend == null) {
            return;
        }
    }

    public JCChartArea getChartArea() {
        return this.chartArea;
    }

    public void setChartArea(JCChartArea jCChartArea) {
        if (jCChartArea == null) {
            return;
        }
    }

    public ChartDataView getDataView(int n) {
        ChartDataView chartDataView = null;
        try {
            chartDataView = (ChartDataView)this.data.elementAt(n);
        }
        catch (Exception exception) {}
        return chartDataView;
    }

    public ChartDataView addDataView(int n) {
        ChartDataView chartDataView = new ChartDataView();
        chartDataView.setParent(this);
        this.setDataView(n, chartDataView);
        return chartDataView;
    }

    public synchronized void setDataView(int n, ChartDataView chartDataView) {
        if (n < 0 || n > this.data.size()) {
            throw new IllegalArgumentException("Invalid ChartDataView index in JCChart.");
        }
        if (chartDataView != null) {
            chartDataView.setParent(this);
        }
        if (n < this.data.size()) {
            this.data.setElementAt(chartDataView, n);
        } else {
            this.data.insertElementAt(chartDataView, n);
        }
        this.reorderDataViews();
        this.setChanged(true);
    }

    public synchronized void setDataView(ChartDataView[] chartDataViewArray) {
        this.data = new JCVector();
        if (chartDataViewArray == null) {
            return;
        }
        int n = 0;
        while (n < chartDataViewArray.length) {
            if (chartDataViewArray[n] != null) {
                chartDataViewArray[n].setParent(this);
            }
            this.data.setElementAt(n, chartDataViewArray[n]);
            ++n;
        }
        this.setChanged(true);
    }

    public ChartDataView findDataView(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (this.data == null || this.data.size() == 0) {
            return null;
        }
        int n = 0;
        while (n < this.data.size()) {
            ChartDataView chartDataView = (ChartDataView)this.data.elementAt(n);
            if (chartDataView.getName().equals(string)) {
                return chartDataView;
            }
            ++n;
        }
        return null;
    }

    public ChartDataView[] getDataView() {
        if (this.data == null || this.data.size() == 0) {
            return null;
        }
        ChartDataView[] chartDataViewArray = new ChartDataView[this.data.size()];
        int n = 0;
        while (n < chartDataViewArray.length) {
            chartDataViewArray[n] = (ChartDataView)this.data.elementAt(n);
            ++n;
        }
        return chartDataViewArray;
    }

    public void removeDataView(int n) {
        try {
            this.chartArea.removeDrawable((ChartDataView)this.data.elementAt(n));
            this.data.removeElementAt(n);
            this.reorderDataViews();
            this.setChanged(true);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public int getNumData() {
        int n = 0;
        try {
            if (this.data != null) {
                n = this.data.size();
            }
        }
        catch (Exception exception) {}
        return n;
    }

    public EventTrigger getTrigger(int n) {
        EventTrigger eventTrigger = null;
        try {
            eventTrigger = (EventTrigger)this.triggers.elementAt(n);
        }
        catch (Exception exception) {}
        return eventTrigger;
    }

    public int getNumTriggers() {
        int n = 0;
        try {
            if (this.triggers != null) {
                n = this.triggers.size();
            }
        }
        catch (Exception exception) {}
        return n;
    }

    public EventTrigger addTrigger() {
        EventTrigger eventTrigger = null;
        try {
            EventTrigger eventTrigger2 = new EventTrigger();
            this.triggers.addElement(eventTrigger2);
            eventTrigger = eventTrigger2;
        }
        catch (Exception exception) {}
        return eventTrigger;
    }

    public synchronized void setTrigger(int n, EventTrigger eventTrigger) {
        if (this.triggers == null) {
            return;
        }
        if (eventTrigger == null) {
            if (n < 0 || n >= this.triggers.size()) {
                throw new IllegalArgumentException("Invalid EventTrigger index.");
            }
            this.removeTrigger(n);
            return;
        }
        if (n < 0 || n > this.triggers.size()) {
            throw new IllegalArgumentException("Invalid EventTrigger index.");
        }
        this.triggers.insertElementAt(eventTrigger, n);
    }

    public void removeTrigger(int n) {
        try {
            this.triggers.removeElementAt(n);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    EventTrigger findMatchingTrigger(int n) {
        n = EventTrigger.adjustModifier(n);
        if (this.triggers == null) {
            return null;
        }
        EventTrigger eventTrigger = null;
        int n2 = 0;
        while (n2 < this.triggers.size()) {
            EventTrigger eventTrigger2 = (EventTrigger)this.triggers.elementAt(n2);
            if (eventTrigger2.modifiers == n) {
                eventTrigger = eventTrigger2;
                break;
            }
            ++n2;
        }
        return eventTrigger;
    }

    public synchronized void setResetKey(int n) {
        this.resetKey = n;
    }

    public int getResetKey() {
        return this.resetKey;
    }

    public synchronized void setCancelKey(int n) {
        this.cancelKey = n;
    }

    public int getCancelKey() {
        return this.cancelKey;
    }

    public void rotateStart() {
    }

    public void rotate() {
    }

    public void rotateEnd() {
    }

    public void zoom(double d, double d2, JCAxis jCAxis, boolean bl) {
        if (jCAxis == null) {
            return;
        }
        double d3 = JCChartUtil.calcError(jCAxis.precision.value);
        if (Math.abs(d - d2) < d3) {
            return;
        }
        if (d > d2) {
            double d4 = d;
            d = d2;
            d2 = d4;
        }
        jCAxis.min.value = d;
        jCAxis.min.isDefault = false;
        jCAxis.max.value = d2;
        jCAxis.max.isDefault = false;
        jCAxis.setChanged(true, false);
        this.sendEvent(jCAxis);
        if (bl) {
            this.chartArea.setChanged(true);
        }
    }

    public void scale(double d, JCAxis jCAxis, boolean bl) {
        if (jCAxis == null) {
            return;
        }
        jCAxis.min.value /= d;
        jCAxis.min.isDefault = false;
        jCAxis.max.value /= d;
        jCAxis.max.isDefault = false;
        jCAxis.setChanged(true, false);
        this.sendEvent(jCAxis);
        if (bl) {
            this.chartArea.setChanged(true);
        }
    }

    public void translateStart(JCAxis jCAxis) {
        if (jCAxis == null) {
            return;
        }
        jCAxis.min.isDefault = false;
        jCAxis.max.isDefault = false;
        this.sendEvent(jCAxis);
        jCAxis.setChanged(true, false);
    }

    public void translate(double d, JCAxis jCAxis, boolean bl) {
        if (jCAxis == null) {
            return;
        }
        jCAxis.translate(d);
        this.sendEvent(jCAxis);
        if (bl) {
            this.chartArea.setChanged(true);
        }
    }

    public void reset() {
        this.chartArea.reset();
    }

    public void cancel() {
        this.chartArea.cancel();
    }

    void reorderDataViews() {
        int n = 0;
        while (n < this.data.size()) {
            ChartDataView chartDataView = (ChartDataView)this.data.elementAt(n);
            chartDataView.drawingOrder = n++;
        }
    }

    public Insets insets() {
        return this.margins;
    }

    public synchronized void setTopMargin(int n) {
        this.margins.top = n;
        this.setChanged(true);
    }

    public int getTopMargin() {
        return this.margins.top;
    }

    public synchronized void setLeftMargin(int n) {
        this.margins.left = n;
        this.setChanged(true);
    }

    public int getLeftMargin() {
        return this.margins.left;
    }

    public synchronized void setRightMargin(int n) {
        this.margins.right = n;
        this.setChanged(true);
    }

    public int getRightMargin() {
        return this.margins.right;
    }

    public synchronized void setBottomMargin(int n) {
        this.margins.bottom = n;
        this.setChanged(true);
    }

    public int getBottomMargin() {
        return this.margins.bottom;
    }

    private int getOffset() {
        return this.offset;
    }

    private synchronized void setOffset(int n) {
        this.offset = n;
        this.setChanged(true);
    }

    public String getAbout() {
        return "JClass Chart by KL Group (http://www.klg.com)";
    }

    public synchronized void setAbout(String string) {
    }

    ChartDataView findData(JCAxis jCAxis) {
        if (jCAxis == null) {
            return null;
        }
        int n = 0;
        while (n < this.data.size()) {
            ChartDataView chartDataView = (ChartDataView)this.data.elementAt(n);
            if (chartDataView.xaxis == jCAxis || chartDataView.yaxis == jCAxis) {
                return chartDataView;
            }
            ++n;
        }
        return null;
    }

    public JCDataIndex pick(Point point, ChartDataView chartDataView) {
        Point point2 = new Point(point.x, point.y);
        Component component = this.locate(point2.x, point2.y);
        if (component == null) {
            return null;
        }
        point2.x -= component.location().x;
        point2.y -= component.location().y;
        if (component instanceof JCTitle) {
            JCDataIndex jCDataIndex = new JCDataIndex(-1, null, -1);
            jCDataIndex.obj = component;
            return jCDataIndex;
        }
        if (component instanceof JCLegend) {
            return this.legend.pick(point2, chartDataView);
        }
        if (component instanceof JCChartArea) {
            return this.chartArea.pick(point2, chartDataView, -1);
        }
        return null;
    }

    public Point unpick(ChartDataView chartDataView, int n, int n2) {
        Serializable serializable;
        if (n2 == -1) {
            return null;
        }
        if (n2 >= 0) {
            serializable = chartDataView.getSeries(n2);
            int n3 = serializable.getFirstPoint();
            int n4 = serializable.getLastPoint();
            if (n < n3 || n > n4) {
                return null;
            }
        }
        if ((serializable = this.chartArea.getDrawable(chartDataView).unpick(n, n2)) != null) {
            Point point = this.chartArea.location();
            ((Point)serializable).x += point.x;
            ((Point)serializable).y += point.y;
            Rectangle rectangle = this.chartArea.getDrawingArea();
            ((Point)serializable).x += rectangle.x;
            ((Point)serializable).y += rectangle.y;
        }
        return serializable;
    }

    public Point unpick(int n, ChartDataViewSeries chartDataViewSeries) {
        if (chartDataViewSeries == null) {
            return null;
        }
        return this.unpick(chartDataViewSeries.parent, n, chartDataViewSeries.parent.getSeriesIndex(chartDataViewSeries));
    }

    public void addChartListener(JCChartListener jCChartListener) {
        this.listeners.addElement(jCChartListener);
    }

    public void removeChartListener(JCChartListener jCChartListener) {
        this.listeners.removeElement(jCChartListener);
    }

    void sendEvent(JCAxis jCAxis) {
        JCChartEvent jCChartEvent = new JCChartEvent(this, jCAxis);
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((JCChartListener)enumeration.nextElement()).changeChart(jCChartEvent);
        }
    }

    public void addPickListener(JCPickListener jCPickListener) {
        this.pickListeners.addElement(jCPickListener);
    }

    public void removePickListener(JCPickListener jCPickListener) {
        this.pickListeners.removeElement(jCPickListener);
    }

    private void sendPickEvent(JCDataIndex jCDataIndex) {
        JCPickEvent jCPickEvent = new JCPickEvent(this, jCDataIndex);
        Enumeration enumeration = this.pickListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((JCPickListener)enumeration.nextElement()).pick(jCPickEvent);
        }
    }

    boolean isNetscape() {
        String string = System.getProperty("browser");
        return string.equalsIgnoreCase("Netscape Navigator");
    }

    public boolean mouseUp(Event event, int n, int n2) {
        Applet applet = this.getApplet();
        try {
            if (this.url != null && applet != null && JCString.showURL(this.url, applet.getAppletContext(), applet)) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.url != null) {
            return false;
        }
        EventTrigger eventTrigger = this.findMatchingTrigger(event.modifiers);
        if (eventTrigger != null) {
            switch (eventTrigger.action) {
                case 4: {
                    this.sendPickEvent(this.pick(new Point(n, n2), null));
                    break;
                }
            }
        }
        return false;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        if (this.dwellLabels != null && this.dwellLabels.size() != 0) {
            Enumeration enumeration = this.dwellLabels.elements();
            while (enumeration.hasMoreElements()) {
                JCChartLabel jCChartLabel = (JCChartLabel)enumeration.nextElement();
                jCChartLabel.hide();
            }
            this.currentDwellLabel = null;
        }
        return false;
    }

    public boolean keyDown(Event event, int n) {
        if (n == 97) {
            JCAboutBox jCAboutBox = new JCAboutBox(BWTUtil.getFrame(this), BWTUtil.getApplet(this));
            jCAboutBox.show();
            return true;
        }
        return super.keyDown(event, n);
    }

    public Component locate(int n, int n2) {
        Component[] componentArray = this.getComponents();
        int n3 = 0;
        while (n3 < componentArray.length) {
            Rectangle rectangle;
            if (componentArray[n3] instanceof ChartCanvas ? ((ChartCanvas)componentArray[n3]).getIsShowing() && (rectangle = new Rectangle(componentArray[n3].location(), componentArray[n3].size())).inside(n, n2) : componentArray[n3].isShowing() && (rectangle = new Rectangle(componentArray[n3].location(), componentArray[n3].size())).inside(n, n2)) {
                return componentArray[n3];
            }
            ++n3;
        }
        return null;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        Component component;
        Object object;
        Object object2 = null;
        Component component2 = this.locate(n, n2);
        if (component2 == null) {
            return true;
        }
        if (n == this.lastx && n2 == this.lasty) {
            return true;
        }
        this.lastx = n;
        this.lasty = n2;
        if (component2 instanceof JCChartArea && this.dwellLabels != null && this.dwellLabels.size() != 0) {
            object = this.dwellLabels.elements();
            while (object.hasMoreElements()) {
                component = (JCChartLabel)object.nextElement();
                if (((JCChartLabel)component).shouldPopupHere(n, n2)) {
                    int n3 = ((JCChartLabel)component).getDwellDelay();
                    if (n3 <= 0) {
                        component.show();
                        continue;
                    }
                    if (this.timer == null) {
                        this.timer = new Timer(1000);
                        this.timer.addTimerListener(this);
                    }
                    this.timer.setTime(n3);
                    this.currentDwellLabel = component;
                    continue;
                }
                component.hide();
            }
            this.dwellPointerX = n;
            this.dwellPointerY = n2;
        }
        object = new Point(n -= component2.location().x, n2 -= component2.location().y);
        if (component2 instanceof JCTitle) {
            ((JCTitle)component2).getLabel();
            object2 = ((JCTitle)component2).getLabel().getRealContents();
            ((Point)object).x -= ((JCTitle)component2).getDrawingArea().x;
            ((Point)object).y -= ((JCTitle)component2).getDrawingArea().y;
        } else {
            if (component2 instanceof JCLegend) {
                return true;
            }
            if (component2 instanceof JCChartArea) {
                ((Point)object).x -= ((JCChartArea)component2).getDrawingArea().x;
                ((Point)object).y -= ((JCChartArea)component2).getDrawingArea().y;
                object2 = this.axisChartLabelHit(((JCChartArea)component2).xaxes, (Point)object);
                if (object2 == null) {
                    object2 = this.axisChartLabelHit(((JCChartArea)component2).yaxes, (Point)object);
                }
            } else {
                return true;
            }
        }
        this.url = object2 != null && object2 instanceof JCString ? JCString.getURL(this.getApplet(), object2, ((Point)object).x, ((Point)object).y) : null;
        component = this.getFrame();
        if (component != null) {
            if (this.url != null) {
                ((Frame)component).setCursor(12);
            } else {
                ((Frame)component).setCursor(0);
            }
        }
        return true;
    }

    public void timerExpired(Timer timer) {
        JCDataIndex jCDataIndex;
        ChartDataView chartDataView;
        if (this.currentDwellLabel != null && (chartDataView = this.currentDwellLabel.getDataView()) != null && (jCDataIndex = this.pick(new Point(this.dwellPointerX, this.dwellPointerY), chartDataView)) != null && jCDataIndex.equals(this.currentDwellLabel.getDataIndex())) {
            this.currentDwellLabel.recalc();
            this.currentDwellLabel.show();
        }
    }

    private Object axisChartLabelHit(JCVector jCVector, Point point) {
        JCString jCString = null;
        int n = point.x;
        int n2 = point.y;
        int n3 = 0;
        while (n3 < jCVector.size() && jCString == null) {
            JCAxis jCAxis = (JCAxis)jCVector.elementAt(n3);
            JCAxisTitle jCAxisTitle = jCAxis.getTitle();
            if (jCAxisTitle != null && jCAxisTitle.isShowing && n >= jCAxisTitle.getLeft() && n < jCAxisTitle.getLeft() + jCAxisTitle.getWidth() && n2 >= jCAxisTitle.getTop() && n2 < jCAxisTitle.getTop() + jCAxisTitle.getHeight()) {
                jCString = jCAxisTitle.realContents;
                break;
            }
            if (jCAxis.isShowing && n >= jCAxis.getLeft() && n < jCAxis.getLeft() + jCAxis.getWidth() && n2 >= jCAxis.getTop() && n2 < jCAxis.getTop() + jCAxis.getHeight()) {
                JCVector jCVector2 = jCAxis.getAnnotations();
                int n4 = 0;
                while (n4 < jCVector2.size()) {
                    ChartText chartText = ((JCValueLabel)jCVector2.elementAt(n4)).getChartText();
                    if (chartText.isShowing && n >= chartText.getLeft() && n < chartText.getLeft() + chartText.getWidth() && n2 >= chartText.getTop() && n2 < chartText.getTop() + chartText.getHeight()) {
                        jCString = chartText.realContents;
                        break;
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        return jCString;
    }

    private Frame getFrame() {
        Container container = this;
        JCChart jCChart = this;
        while (jCChart != null && !(jCChart instanceof Frame)) {
            jCChart = container;
            if (container == null) continue;
            container = container.getParent();
        }
        return (Frame)((Object)jCChart);
    }

    public Image snapshot() {
        Image image = this.createImage(this.size().width, this.size().height);
        if (image != null) {
            this.print(image.getGraphics());
        }
        return image;
    }

    public void addChartLabel(JCChartLabel jCChartLabel) {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] == jCChartLabel) {
                return;
            }
            ++n;
        }
        jCChartLabel.setParentChart(this);
        this.addToDwellLabels(jCChartLabel);
        this.addChartListener(jCChartLabel);
        if (browser == 3) {
            this.add((Component)jCChartLabel, -1);
            return;
        }
        if (JCEnvironment.getOS() == 1 && JCEnvironment.getJavaVersion() == 102) {
            this.add((Component)jCChartLabel, 0);
            return;
        }
        this.remove(this.chartArea);
        this.add((Component)jCChartLabel, 0);
        this.add((Component)this.chartArea, -1);
    }

    public void removeChartLabel(JCChartLabel jCChartLabel) {
        this.remove(jCChartLabel);
        this.removeFromDwellLabels(jCChartLabel);
        this.removeChartListener(jCChartLabel);
    }

    void addToDwellLabels(JCChartLabel jCChartLabel) {
        if (this.dwellLabels != null && this.dwellLabels.contains(jCChartLabel)) {
            return;
        }
        if (jCChartLabel.getIsDwellLabel()) {
            if (this.dwellLabels == null) {
                this.dwellLabels = new JCVector();
            }
            this.dwellLabels.addElement(jCChartLabel);
            jCChartLabel.hide();
        }
    }

    void removeFromDwellLabels(JCChartLabel jCChartLabel) {
        if (this.dwellLabels == null || !this.dwellLabels.contains(jCChartLabel)) {
            return;
        }
        this.dwellLabels.removeElement(jCChartLabel);
        jCChartLabel.show();
        if (this.dwellLabels.size() == 0) {
            this.dwellLabels = null;
        }
    }

    void updateChartLabels() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof JCChartLabel) {
                JCChartLabel jCChartLabel = (JCChartLabel)componentArray[n];
                jCChartLabel.recalc();
            }
            ++n;
        }
    }

    public void addNotify() {
        JCVector jCVector = new JCVector();
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (BWTUtil.instanceOf(componentArray[n], "JCChartLabel")) {
                jCVector.add(componentArray[n]);
            }
            ++n;
        }
        this.removeAll();
        super.addNotify();
        browser = JCEnvironment.getBrowser(this);
        if (browser == 3) {
            this.add(this.chartArea);
            this.add(this.header);
            this.add(this.footer);
            this.add(this.legend);
        } else {
            this.add(this.legend);
            this.add(this.header);
            this.add(this.footer);
            this.add(this.chartArea);
        }
        int n2 = 0;
        while (n2 < jCVector.size()) {
            this.addChartLabel((JCChartLabel)jCVector.elementAt(n2));
            ++n2;
        }
    }
}

